"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper";
import { useListAllUsers } from "../hooks/use-list-all-users";
import { Text } from "@/components/typeography/text"
import { InvitesTable } from "./invites.table";

export function InvitesTableClient() {
  const res = useListAllUsers();
  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: null,
      }}
      content={(data) => {
        if (!data?.pending || data.pending.length === 0) {
          return null;
        }

        return (
          <div className="text-pretty grid gap-6 lg:gap-0 lg:grid-cols-[24rem,_1fr] xl:grid-cols-2">
            <div>
              <Text variant={"h3"} affects={"lead"}>Pending Invites</Text>
              <Text variant={"p"} affects={"subtle"} tint={"muted"}>Users listed are pending verification to their email address. A one time password has been sent to the associated email. If no one time password was sent, revoke the invitation and try again.</Text>
            </div>

            <InvitesTable data={data.pending} />
          </div>

        )
      }}
    />
  )
}
